-- Add indexes for better query performance
-- This script will show warnings if indexes already exist, but will not fail

-- To run this script without errors, you can either:
-- 1. Ignore the warnings if indexes already exist, or
-- 2. Manually drop existing indexes first, or
-- 3. Check which indexes exist and only create the missing ones

-- Index on posts.category_id for faster joins
CREATE INDEX idx_posts_category_id ON posts(category_id);

-- Index on posts.slug for faster lookups
CREATE INDEX idx_posts_slug ON posts(slug);

-- Index on posts.created_at for faster sorting
CREATE INDEX idx_posts_created_at ON posts(created_at);

-- Index on categories.slug for faster lookups
CREATE INDEX idx_categories_slug ON categories(slug);

-- Index on post_tags.post_id for faster joins
CREATE INDEX idx_post_tags_post_id ON post_tags(post_id);

-- Index on post_tags.tag_id for faster joins
CREATE INDEX idx_post_tags_tag_id ON post_tags(tag_id);

-- Index on attachments.post_id for faster joins
CREATE INDEX idx_attachments_post_id ON attachments(post_id);

-- Index on attachments.sort_order for faster sorting
CREATE INDEX idx_attachments_sort_order ON attachments(sort_order);

-- Index on attachments.uploaded_at for faster sorting
CREATE INDEX idx_attachments_uploaded_at ON attachments(uploaded_at);

-- Composite index for category counting query
CREATE INDEX idx_posts_category_count ON posts(category_id, id);